<?php
/* --------------------------------------------------------------
  ReaderInterface.php 2020-02-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Repository\Reader;

/**
 * Interface ReaderInterface
 * @package Gambio\Shop\Attributes\SellingUnitEan\Repository\Reader
 */
interface ReaderInterface
{
    /**
     * @param array $optionIds
     * @param int   $productId
     *
     * @return array
     */
    public function getEanValuesByProductId(array $optionIds, int $productId) : array;
}